#include "mvminer.h"

t_item MAXITEM = ~0;     // nombre maximum d'attributs autoris�s
t_support MAXTRANS = ~0; // idem nb transactions

ostream *fichResult = &cout;


//----------------------------------------------------------------
// indique le nombre d'items de la cha�ne s
t_item nbitems(char *s){
  t_item ret = 0;
  // calcul # items
  do{
    if(*s == ' ') ret ++;
    s ++;
  }while(*s);
  return ret;
}

//----------------------------------------------------------------
template <class c_class>
c_class longueur(c_class *liste){
  c_class ret = 0;
  while(*liste){
    ret ++;
    liste ++;
  }
  return ret;
}

//----------------------------------------------------------------
template <class c_class>
vector<c_class> *settovector(set<c_class> *ens){
  vector<c_class> *ret = new vector<c_class>;
  typename set<c_class>::iterator i = ens->begin(), end = ens->end();
  while(i != end){
    ret->push_back(*i);
    i ++;
  }
  return ret;
}

//----------------------------------------------------------------
/* template <class c_class> */
/* void affiche(c_class *ptr){ */
/*   while(*ptr) */
/*     cout << (int)*ptr++ << ' '; */
/* } */

//-----------------------------------------------------------------
void Caffiche(t_item *ptr){
  while(*ptr)
    cout << (int)*ptr++ << ' ';
}

//-----------------------------------------------------------------
void afficheitem(t_item *ptr, ostream &os){
  while(*ptr)
    os << (int)*ptr++ << ' ';
}

//-----------------------------------------------------------------
void affichelongdnf(t_longdnf *ptr, t_item ncolonne){
  while(*ptr && ncolonne){
    cout << (int)*ptr++ << ' ';
    ncolonne --;
  }
}

//-----------------------------------------------------------------
void ognion(t_item *dest, t_item *src, t_item x){
  // r�alise dans this l'union de �l�ment, parcours de ptree et x
  while(*src && *src < x) {
    *dest = *src;
    dest ++; src ++;
  }
  *dest = x;
  dest ++;
  while(*src            ) {
    *dest = *src;
    dest ++;
    src ++;
  }
  *dest = 0;
}

// -------------------------------------------------------------------
bool intersection(t_item *src, t_item *motif){
  // indique si la src contient un �l�ment du motif
  do{
    if(*src == *motif) return true;
    if(*src < *motif) src ++; else motif ++;
  }while(*src && *motif);
  return false;
}

// -------------------------------------------------------------------
bool intersection(t_item *src, set<t_item> *ligne){
  // indique si la src contient un �l�ment du motif
  static set<t_item>::iterator motif, end; motif = ligne->begin(); end = ligne->end();
  do{
    if(*src == *motif) return true;
    if(*src < *motif) src ++; else motif ++;
  }while(*src && (motif != end));
  return false;
}

// -------------------------------------------------------------------
// union de 2 set d'items
set<t_item> unionsetret;

set<t_item> &unionsetitem(set<t_item> &set1, set<t_item> &set2){
  unionsetret.clear();
  set_union(set1.begin(), set1.end(), set2.begin(), set2.end(), inserter(unionsetret, unionsetret.begin()));
  return unionsetret;
}

//-----------------------------------------------------------------
//-----------------------------------------------------------------
//-----------------------------------------------------------------
char *fgetline2(istream *fich){
  string buff;
  getline(*fich, buff);
  return strdup(buff.c_str());
}

//-----------------------------------------------------------------
//-----------------------------------------------------------------
//-----------------------------------------------------------------
// lit une ligne dans un fichier, sans limitation de taille,
// et retourne un pointeur dessus
char *fgetline(istream *fich){
#define LIGNE 1024
  char *s,*result;
  int n = 1, i;
  // allocation de la chaine temporaire de sauvegarde du r�sultat
  // car elle est d�truite dans le do
  char *tempo = new char[1];
  *tempo = 0;
  while(true){
    i = 0;
    result = new char[LIGNE * n + 1];
    strcpy(result, tempo);
    delete[] tempo;
    // s pointe sur la partie additionnelle de result � lire
    s = result + LIGNE * (n - 1) - 1;
    // lecture char par char, LIGNE au max
    do{
      s++;
      *s = (char)fich->get();
      i++;
    }while((!fich->eof()) && (*s != '\n') && (i < LIGNE));
    if(fich->eof() || *s == '\n'){
      if(*(s - 1) == '\r') s--;               // compatibilit� DOS
      *s = 0;
      return result;
    }
    // (else...) marqueur de fin de cha�ne
    *(s + 1) = 0;
    n++;
    // backup
    tempo = result;
  }
}

//-----------------------------------------------------------------
//-----------------------------------------------------------------
//-----------------------------------------------------------------
float estreel(char *buffer) throw(string){
  // on lit la cha�ne par l'arri�re et on construit l'exposant (la
  // valeur si c'est un entier). S'il y a 'e' on continue jusqu'au '.'
  // pour lire la mantisse.
  float val;
  char *s = buffer;
  if(!*s) throw string("empty string forbidden");

  // positionnement fin de cha�ne
  do s++; while(*s);
  s --;

  // lecture exposant
  bool encore = true;
  if(*s == '+' || *s == '-') throw string("format error");
  do{
    switch(*s){
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
      if(s != buffer) s--; else encore = false;
      break;
    case '-': case '+':
      s --;
    case '.': case 'e': case 'E':
      encore = false;
      break;
    default : throw string("forbidden char");
    }
  }while(encore);

  if(*s != 'e' && *s != 'E' && *s != '.'){
    if(s == buffer){ sscanf(buffer, "%f", &val); return val;}
    throw string("erreur de format");
  }

  if(*s != '.'){       // on a lu l'exposant...
    s--;

    encore = true;
    do{
      switch(*s){
      case '0': case '1': case '2': case '3': case '4':
      case '5': case '6': case '7': case '8': case '9':
	if(s != buffer) s--; else encore = false;
	break;
      case '.':
	encore = false;
      }
    }while(encore);

    if(s == buffer) throw string("format error");
  }
  s--;

  // mantisse entiere
  encore = true;
  if(*s == '+' || *s == '-') throw string("format error");
  while(encore){
    switch(*s){
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
      if(s != buffer) s--; else encore = false;
      break;
    case '-': case '+':
      encore = false;
      break;
    default : throw string("forbidden char");
    }
  }while(encore);

  if(s == buffer)  { sscanf(buffer, "%f", &val); return val; }
  throw string("format error");
}

t_contingence chisquare(t_support f11, t_support f12, t_support f21, t_support f22){
  t_support f[3][3];   // la ligne et la colonne 0 contiennent les sommes
  t_contingence e[3][3];
  f[1][1] = f11;
  f[1][2] = f12;
  f[2][1] = f21;
  f[2][2] = f22;

  f[0][1] = f11 + f21;
  f[0][2] = f12 + f22;
  f[1][0] = f11 + f12;
  f[2][0] = f21 + f22;

  f[0][0] = f[0][1] + f[0][2];

  //calcul des esp�rances
  for(int i = 1; i <= 2 ; i ++)
    for(int j = 1; j <= 2 ; j ++)
      e[i][j] = (t_contingence)f[i][0] * f[0][j] / f[0][0];

  t_contingence ret = 0;
  for(int i = 1; i <= 2 ; i ++)
    for(int j = 1; j <= 2 ; j ++)
      ret += (f[i][j] - e[i][j]) * (f[i][j] - e[i][j]) / e[i][j];
  // cout << "e" << ret << endl;
  return ret;
}

t_contingence chisquaremax(t_support P, t_support C, t_support T){
  t_contingence e =
    1.0 / (   P     *    C)    + 1.0 / (   P     * (T - C)) +
    1.0 / ((T - P)  * (T - C)) + 1.0 / ((T - P)  *     C);
  return SQUARE(MIN(P, C) - (t_contingence)(P * C) / T) * T * e;
}


