/* 
 * File:   mvminer.h
 * Author: frioult
 *
 * Created on 2 octobre 2009, 23:50
 */

#ifndef _MVMINER_H
#define	_MVMINER_H

using namespace std;

#include <cmath>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <set>
#include <string>
#include <iterator>
#include <map>
#include <deque>
#include <sstream>
#include <list>
#include <string.h>
#include <algorithm>

typedef string::size_type size_type;

typedef unsigned short int baseType;
typedef short baseTypeSigned;

typedef baseType t_item;
typedef baseTypeSigned t_itemsigne;
typedef unsigned int t_support;     /* int si plus de 32000 transactions */
typedef baseTypeSigned t_supportsigne;

#define MAXCOL 32767
#define MAXROW 32767

// importé de mvkompletor.h
typedef t_itemsigne Colonne;
typedef t_support Ligne;
typedef float TMesure;

typedef unsigned char t_hedge;
typedef unsigned int  t_hypergraph;

typedef unsigned int t_longdnf;

extern t_item MAXITEM;     // nombre maximum d'attributs autoris�s
extern t_support MAXTRANS; // idem nb transactions

extern ostream *fichResult;
extern float estreel(char *buffer) throw(string);

typedef unsigned int t_homo;   // homog�n��t�

/// intersection de deux ensembles : utilise un inserter pour le r�sultat
template<class c_class>
void intersection(set<c_class> &set1, set<c_class> &set2, set<c_class> &out){
  out.clear();
  set_intersection(set1.begin(), set1.end(), set2.begin(), set2.end(), inserter(out, out.begin()));
}

template<class c_class>
void difference(set<c_class> &set1, set<c_class> &set2, set<c_class> &out){
  out.clear();
  set_difference(set1.begin(), set1.end(), set2.begin(), set2.end(), inserter(out, out.begin()));
}

template<class c_class>
void ognion(set<c_class> &set1, set<c_class> &set2, set<c_class> &out){
  out.clear();
  set_union(set1.begin(), set1.end(), set2.begin(), set2.end(), inserter(out, out.begin()));
}

/// quelques cha�nes C ou caract�res
#define SUPPORT_CHARC ": "
#define NBTRANS_CHARC 't'
#define NBATTR_CHARC 'a'
#define HOMOGENEITEA_CHARC ';'
#define HOMOGENEITET_CHARC '|'
//#define CONCENTRATION '|'
#define TRANSACTION_CHARC '+'
#define FERMETURE_CHARC ", "

/// tirage al�atoire
#define RAND(n) (int)((float)(n + 1)*rand()/(RAND_MAX + 1.0))  // dans [0, n]

/// valeur absolue
#define ABS(a) ((a) >= 0 ? (a) : (- (a)))
/// max
#define MAX(a,b) ((a) > (b) ? (a) : (b))
/// min
#define MIN(a,b) ((a) < (b) ? (a) : (b))
/// carr�
#define SQUARE(a) ((a) * (a))
/// impair
#define ODD(a) ((a) & 1)

//----------------------------------------------------------------
t_item nbitems(char *s);
template <class c_class> c_class longueur(c_class *liste);
template <class c_class> vector<c_class> *settovector(set<c_class> *ens);
void Caffiche(t_item *ptr);
void afficheitem(t_item *ptr, ostream &os = *fichResult);
void affichelongdnf(t_longdnf *ptr, t_item ncolonne);
void ognion(t_item *dest, t_item *src, t_item x);
// r�alise dans this l'union de �l�ment, parcours de ptree et x
bool intersection(t_item *src, t_item *motif);
// indique si la src contient un �l�ment du motif
bool intersection(t_item *src, set<t_item> *ligne);
// indique si la src contient un �l�ment du motif
char *fgetline(istream *fich);
// lit une ligne dans un fichier, sans limitation de taille,
// et retourne un pointeur dessus

set<t_item> &unionsetitem(set<t_item> &set1, set<t_item> &set2);

//-----------------------------------------------------------------
template <class c_class>
void moins(c_class *Z, c_class *X, c_class *Y){
  // � partir de X et Z, calcule Z \ X
  do {
    if(*Z == *X) X ++;
    else { *Y = *Z; Y ++; }
    Z ++;
  }
  while(*Z);
  *Y = 0;
}

//-----------------------------------------------------------------
template <class c_class>
c_class *dup(c_class *dest, c_class *src){
  // dupplique src dans dest
  c_class *ret = dest;
  while(*src) {
    *dest = *src;
    dest ++; src ++;
  }
  *dest = 0;
  return ret;
}

//-----------------------------------------------------------------
template <class c_class>
c_class *cat(c_class *dest, c_class *src){
  // concat�ne src dans dest
  c_class *ret = dest;
  while(*dest) dest ++;
  while(*src) {
    *dest = *src;
    dest ++; src ++;
  }
  *dest = 0;
  return ret;
}


// -------------------------------------------------------------------
typedef float t_contingence;

t_contingence chisquaremax(t_support P, t_support C, t_support T);
t_contingence chisquare(t_support f11, t_support f12, t_support f21, t_support f22);



#endif	/* _MVMINER_H */

